﻿/*----------------------------------------------------------------
             文件名：openlayers-extend.js
             文件功能描述：因业务需要而添加的OpenLayers扩展包
----------------------------------------------------------------*/
OpenLayers.Control.DHNavigation  = OpenLayers.Class(OpenLayers.Control.Navigation,{
	 /**
     * Method: defaultDblClick 
     * 
     * Parameters:
     * evt - {Event} 
     */
    defaultDblClick: function (evt) {
		return;
    },

    /**
     * Method: defaultDblRightClick 
     * 
     * Parameters:
     * evt - {Event} 
     */
    defaultDblRightClick: function (evt) {
        return;
    }
})

//标记扩展增加唯一标识和文本备注
OpenLayers.DHMarker  = OpenLayers.Class(OpenLayers.Marker,{
	id:null,//标记唯一标识
	markerType:null,//标记类型
	selected:false,//是否选中
	/**
	 * 标记初始化执行函数
	 * @param	markerId	标记唯一标识
	 * @param 	lonlat		系统触发事件
	 * @param 	icon 		地图对象
	 * @param	text		图像拖拽鼠标样式
	 * @author	jquan_zhang
	*/
	initialize: function(markerId,lonlat,icon,text,markerType){
		this.lonlat = lonlat;
		this.markerType = markerType;
		var newIcon = (icon) ? icon : OpenLayers.Marker.defaultIcon();
		if (this.icon == null) {
			this.icon = newIcon;
		} else {
			this.icon.url = newIcon.url;
			this.icon.size = newIcon.size;
			this.icon.offset = newIcon.offset;
			this.icon.calculateOffset = newIcon.calculateOffset;
		}
		this.text = (text) ? text : "";
		if(this.text != ""){
			var left = (parseInt(this.icon.size.w)+2)+"px";
			var top = (parseInt(this.icon.size.h)/2-10)+"px";
			var str = "";
				str+= "<label name='markerTitle' style='position:absolute;left:"+left+";top:"+top+";background:#dedfe3;border:1px #797e92 solid;fontFamily:宋体;font-size:12px;color:#3d4770;white-space:nowrap;' >";
				str+= this.text;
				str+= "</label>";
			var imageDivStr = this.icon.imageDiv.innerHTML;
			this.icon.imageDiv.innerHTML = imageDivStr + str;
			this.icon.imageDiv.className = "marker_" + markerType;
		}
		this.icon.imageDiv.style.width = "auto";
		this.id = markerId?markerId:"";
		this.events = new OpenLayers.Events(this, this.icon.imageDiv);
	}
})

//鹰眼扩展
OpenLayers.Control.DHOverviewMap  = OpenLayers.Class(OpenLayers.Control.OverviewMap,{
    maxRatio: 64,
	/**
	 * 画鹰眼方法
	 * @author	jquan_zhang
	*/  
    draw: function() {
        OpenLayers.Control.prototype.draw.apply(this, arguments);
        if (this.layers.length === 0) {
            if (this.map.baseLayer) {
                var layer = this.map.baseLayer.clone();
                this.layers = [layer];
            } else {
                this.map.events.register("changebaselayer", this, this.baseLayerDraw);
                return this.div;
            }
        }

        // create overview map DOM elements
        this.element = document.createElement('div');
        this.element.className = this.displayClass + 'Element';
        this.element.style.display = 'none';

        this.mapDiv = document.createElement('div');
        this.mapDiv.style.width = this.size.w + 'px';
        this.mapDiv.style.height = this.size.h + 'px';
        this.mapDiv.style.position = 'relative';
        this.mapDiv.style.overflow = 'hidden';
        this.mapDiv.id = OpenLayers.Util.createUniqueID('overviewMap');
        this.extentRectangle = document.createElement('div');
        this.extentRectangle.style.position = 'absolute';
        this.extentRectangle.style.zIndex = 1000;  //HACK
        this.extentRectangle.className = this.displayClass+'ExtentRectangle';
        this.extentRectangle.style.border = "#cc5229 3px solid";
        this.extentRectangle.style.background = "#ffaa00";
        this.extentRectangle.style.opacity = "0.4";
        this.extentRectangle.style.filter = "alpha(opacity=40)";
        this.element.appendChild(this.mapDiv);
        this.div.appendChild(this.element);
        // Optionally add min/max buttons if the control will go in the
        // map viewport.
        if(!this.outsideViewport) {
            this.div.className += " " + this.displayClass + 'Container';
            // maximize button div
            var img = OpenLayers.Util.getImageLocation('layer-switcher-maximize.png');
            this.maximizeDiv = OpenLayers.Util.createAlphaImageDiv(
                                        this.displayClass + 'MaximizeButton', 
                                        null, 
                                        null, 
                                        img, 
                                        'absolute');
            this.maximizeDiv.style.display = 'none';
            this.maximizeDiv.className = this.displayClass + 'MaximizeButton olButton';
            this.div.appendChild(this.maximizeDiv);
    
            // minimize button div
            var img = OpenLayers.Util.getImageLocation('layer-switcher-minimize.png');
            this.minimizeDiv = OpenLayers.Util.createAlphaImageDiv(
                                        'OpenLayers_Control_minimizeDiv', 
                                        null, 
                                        null, 
                                        img, 
                                        'absolute');
            this.minimizeDiv.style.display = 'none';
            this.minimizeDiv.className = this.displayClass + 'MinimizeButton olButton';
            this.div.appendChild(this.minimizeDiv); 
            this.minimizeControl();
        } else {
            // show the overview map
            this.element.style.display = '';
        }
        if(this.map.getExtent()) {
            this.update();
        }
        
        this.map.events.on({
            buttonclick: this.onButtonClick,
            moveend: this.update,
            scope: this
        });
        
        if (this.maximized) {
            this.maximizeControl();
        }
	this.element.style.padding=0 ;
	this.maximizeDiv.style.bottom = 0;
	this.maximizeDiv.style.width = "20px";
	this.maximizeDiv.style.height = "20px";
	this.minimizeDiv.style.bottom = 0;
	this.minimizeDiv.style.width = "20px";
	this.minimizeDiv.style.height = "20px";
	this.mapDiv.style.border = "4px solid #D5D6DB";
	this.mapDiv.style.background = "#41465A";
        return this.div;
    },
	/**
     * Method: createMap
     * Construct the map that this control contains
     */
    createMap: function() {
        // create the overview map
		var wMax = parseFloat(this.map.div.style.width)/parseFloat(this.mapDiv.style.width);
		var hMax = parseFloat(this.map.div.style.height)/parseFloat(this.mapDiv.style.height);
		var resolutionMax = wMax>hMax?wMax:hMax;
		var options = OpenLayers.Util.extend({
			controls: [], 
			maxResolution: 'auto',
			fallThrough: false,
			numZoomLevels: 10,
			resolutions: [resolutionMax*this.map.resolutions[1]]
		}, this.mapOptions);
        this.ovmap = new OpenLayers.Map(this.mapDiv, options);
        this.ovmap.viewPortDiv.appendChild(this.extentRectangle);
        // prevent ovmap from being destroyed when the page unloads, because
        // the OverviewMap control has to do this (and does it).
        OpenLayers.Event.stopObserving(window, 'unload', this.ovmap.unloadDestroy);
        this.ovmap.addLayers(this.layers);
        this.ovmap.restrictedExtent = this.ovmap.baseLayer.extent;
        this.ovmap.zoomToMaxExtent();
        // check extent rectangle border width
        this.wComp = parseInt(OpenLayers.Element.getStyle(this.extentRectangle,
                                               'border-left-width')) +
                     parseInt(OpenLayers.Element.getStyle(this.extentRectangle,
                                               'border-right-width'));
        this.wComp = (this.wComp) ? this.wComp : 2;
        this.hComp = parseInt(OpenLayers.Element.getStyle(this.extentRectangle,
                                               'border-top-width')) +
                     parseInt(OpenLayers.Element.getStyle(this.extentRectangle,
                                               'border-bottom-width'));
        this.hComp = (this.hComp) ? this.hComp : 2;

        this.handlers.drag = new OpenLayers.Handler.Drag(
            this, {move: this.rectDrag, done: this.updateMapToRect},
            {map: this.ovmap}
        );
        this.handlers.click = new OpenLayers.Handler.Click(
            this, {
                "click": this.mapDivClick
            },{
                "single": true, "double": false,
                "stopSingle": true, "stopDouble": true,
                "pixelTolerance": 1,
                map: this.ovmap
            }
        );
        this.handlers.click.activate();
        
        this.rectEvents = new OpenLayers.Events(this, this.extentRectangle,
                                                null, true);
        this.rectEvents.register("mouseover", this, function(e) {
            if(!this.handlers.drag.active && !this.map.dragging) {
                this.handlers.drag.activate();
            }
        });
        this.rectEvents.register("mouseout", this, function(e) {
            if(!this.handlers.drag.dragging) {
                this.handlers.drag.deactivate();
            }
        });

        if (this.ovmap.getProjection() != this.map.getProjection()) {
            var sourceUnits = this.map.getProjectionObject().getUnits() ||
                this.map.units || this.map.baseLayer.units;
            var targetUnits = this.ovmap.getProjectionObject().getUnits() ||
                this.ovmap.units || this.ovmap.baseLayer.units;
            this.resolutionFactor = sourceUnits && targetUnits ?
                OpenLayers.INCHES_PER_UNIT[sourceUnits] /
                OpenLayers.INCHES_PER_UNIT[targetUnits] : 1;
        }
    }
})

//放大缩小控制条扩展
OpenLayers.Control.DHPanZoomBar = OpenLayers.Class(OpenLayers.Control.PanZoomBar,{
	 /** 
     * APIProperty: zoomStopWidth
     */
    zoomStopWidth: 35,

    /** 
     * APIProperty: zoomStopHeight
     */
    zoomStopHeight: 10,
	
	 /** 
     * 导航条
     */
    compass:null,
	 /**
    * Method: draw 
    *
    * Parameters:
    * px - {<OpenLayers.Pixel>} 
    */
    draw: function(px) {
        // initialize our internal div
        OpenLayers.Control.prototype.draw.apply(this, arguments);
        px = this.position.clone();
        // place the controls
        this.buttons = [];
        var sz = {w: 20, h: 20};
		var spz = {w:35,h:23};
        if (this.panIcons) {
            var centered = new OpenLayers.Pixel(px.x+sz.w/2+20, px.y);
			px.x += 10;
			this._addButton("compass", "compass.png", centered.add(-32,0), {w:93,h:93});
            var wposition = sz.w;
            if (this.zoomWorldIcon) {
                centered = new OpenLayers.Pixel(px.x+sz.w, px.y);
            }

            this._addButton("panup", "north-mini.png", centered.add(5,20), sz);
            px.y = centered.y+sz.h;
            this._addButton("panleft", "west-mini.png", px.add(10,16), sz);
            if (this.zoomWorldIcon) {
                this._addButton("zoomworld", "zoom-world-mini.png", px.add(sz.w, 0), sz);

                wposition *= 2;
            }
            this._addButton("panright", "east-mini.png", px.add(wposition+21, 16), sz);
            this._addButton("pandown", "south-mini.png", centered.add(5, sz.h*2+12), sz);
            this._addButton("zoomin", "zoom-plus-mini.png", centered.add(-2, sz.h*3+20), spz);
            centered = this._addZoomBar(centered.add(0, sz.h*3+spz.h+ 5 +15));
            this._addButton("zoomout", "zoom-minus-mini.png", centered.add(-2,0), spz);
        }
        else {
            this._addButton("zoomin", "zoom-plus-mini.png", px, spz);
            centered = this._addZoomBar(px.add(0, sz.h));
            this._addButton("zoomout", "zoom-minus-mini.png", centered, spz);
            if (this.zoomWorldIcon) {
                centered = centered.add(0, sz.h+3);
                this._addButton("zoomworld", "zoom-world-mini.png", centered, sz);
            }
        }
        return this.div;
    },
	 /** 
    * Method: _addZoomBar
    * 
    * Parameters:
    * centered - {<OpenLayers.Pixel>} where zoombar drawing is to start.
    */
    _addZoomBar:function(centered) {
        var imgLocation = OpenLayers.Util.getImageLocation("slider.png");
        var id = this.id + "_" + this.map.id;
        var zoomsToEnd = this.map.getNumZoomLevels() - 1 - this.map.getZoom();
        var slider = OpenLayers.Util.createAlphaImageDiv(id,
                       centered.add(-2, zoomsToEnd * this.zoomStopHeight), 
                       {w: 35, h: 10},
                       imgLocation,
                       "absolute");
        slider.style.cursor = "move";
        this.slider = slider;
        this.sliderEvents = new OpenLayers.Events(this, slider, null, true,
                                            {includeXY: true});
        this.sliderEvents.on({
            "touchstart": this.zoomBarDown,
            "touchmove": this.zoomBarDrag,
            "touchend": this.zoomBarUp,
            "mousedown": this.zoomBarDown,
            "mousemove": this.zoomBarDrag,
            "mouseup": this.zoomBarUp
        });
        var sz = {
            w: this.zoomStopWidth,
            h: this.zoomStopHeight * this.map.getNumZoomLevels()
        };
        var imgLocation = OpenLayers.Util.getImageLocation("zoombar.png");
        var div = null;
        
        if (OpenLayers.Util.alphaHack()) {
            var id = this.id + "_" + this.map.id;
            div = OpenLayers.Util.createAlphaImageDiv(id, centered,
                                      {w: sz.w, h: this.zoomStopHeight},
                                      imgLocation,
                                      "absolute", null, "crop");
            div.style.height = sz.h + "px";
        } else {
            div = OpenLayers.Util.createDiv(
                        'OpenLayers_Control_PanZoomBar_Zoombar' + this.map.id,
                        centered.add(-2,0),
                        sz,
                        imgLocation);
        }
        div.style.cursor = "pointer";
        div.className = "olButton";
        this.zoombarDiv = div;
        this.div.appendChild(div);
        this.startTop = parseInt(div.style.top);
        this.div.appendChild(slider);
        this.map.events.register("zoomend", this, this.moveZoomBar);
        centered = centered.add(0, 
            this.zoomStopHeight * this.map.getNumZoomLevels());
		this.zoombarDiv.style.width = "35px";
        return centered; 
    },
	/*
    * Method: moveZoomBar
    * Change the location of the slider to match the current zoom level.
    */
    moveZoomBar:function() {
        var newTop = 
            ((this.map.getNumZoomLevels()-1) - this.map.getZoom()) * 
            this.zoomStopHeight + this.startTop ;
        this.slider.style.top = newTop + "px";
    },
		
	zoomBarDrag:function(evt) {
        if (this.mouseDragStart != null) {
            var deltaY = this.mouseDragStart.y - evt.xy.y;
            var offsets = OpenLayers.Util.pagePosition(this.zoombarDiv);
            if ((evt.clientY - offsets[1]) > 0 && 
                (evt.clientY - offsets[1]) < parseInt(this.zoombarDiv.style.height) - 2) {
                var newTop = parseInt(this.slider.style.top) - deltaY;
                this.slider.style.top = newTop+"px";
                this.mouseDragStart = evt.xy.clone();
            }else{
				this.sliderEvents.triggerEvent("mouseup",evt);
			}
            // set cumulative displacement
			this.deltaY = this.zoomStart.y - evt.xy.y;
			OpenLayers.Event.stop(evt);
        }
    }
    

});